<?php

namespace Database\Seeders;

use App\Models\Testimonial;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class TestimonialSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $testimonials = [
            [
                'author' => 'John D. Smith',
                'content' => 'Excellent care and professional staff. The doctor took time to explain everything clearly and made me feel comfortable throughout the entire process. Highly recommend ENT Care Center!',
                'rating' => 5,
                'is_active' => true,
                'sort_order' => 1,
            ],
            [
                'author' => 'Sarah M. Johnson',
                'content' => 'Very satisfied with my treatment. The facility is clean and modern, and the staff is very helpful. The doctor was knowledgeable and caring. Great experience overall!',
                'rating' => 5,
                'is_active' => true,
                'sort_order' => 2,
            ],
            [
                'author' => 'Michael R. Williams',
                'content' => 'Great experience from start to finish. The team at ENT Care Center is professional, friendly, and truly cares about their patients. I felt well taken care of throughout my treatment.',
                'rating' => 5,
                'is_active' => true,
                'sort_order' => 3,
            ],
            [
                'author' => 'Emily Chen',
                'content' => 'Outstanding service! The doctors are experts in their field and the staff goes above and beyond to ensure patient comfort. I would definitely recommend this clinic to anyone.',
                'rating' => 5,
                'is_active' => true,
                'sort_order' => 4,
            ],
            [
                'author' => 'David Thompson',
                'content' => 'The best ENT care I have ever received. Professional, efficient, and compassionate. The entire team made my visit comfortable and stress-free. Thank you!',
                'rating' => 5,
                'is_active' => true,
                'sort_order' => 5,
            ],
        ];

        foreach ($testimonials as $testimonial) {
            Testimonial::create($testimonial);
        }
    }
}
